/*jslint node: true, nomen: true, unparam: true */
/*global jquery, _, $ */

'use strict';

require.config({
    // 3rd party script alias names (Easier to type "jquery" than "libs/jquery, etc")
    // probably a good idea to keep version numbers in the file names for updates checking
    paths: {
        // Core Libraries
        "jquery": "_assets/libs/jquery/jquery-1.9.1",
        "jqueryui": "_assets/libs/jqueryui/jqueryui-1.9.2",
        //"jquerymobile": "_assets/libs/jqm/jquery.mobile-1.3.1",
        "jquerymobile": "_assets/libs/jqm/jquery.mobile-1.3.1-custom", // option corners, custom longview icons, modified getInheritedTheme
        "underscore": "_assets/libs/marionette/lodash-1.3.1", // 2.4.1 / 1.3.1
        //"backbone": "_assets/libs/marionette/backbone-1.0.0", // 1.1.0 / 1.0.0
        "backbone": "_assets/libs/marionette/backbone-1.0.0-custom", // previousFragment
        "localstorage": "_assets/libs/backbone-localstorage-15.5.5/backbone.localStorage",
        "marionette": "_assets/libs/marionette/backbone.marionette-1.1.0", // 1.4.0 / 1.1.0
        "handlebars": "_assets/libs/handlebars/handlebars-1.0.0",
        "hbs": "_assets/libs/handlebars/hbs-0.4.0",
        "i18nprecompile": "_assets/libs/handlebars/i18nprecompile",
        "json2": "_assets/libs/marionette/json2",
        "jasmine": "_assets/libs/jasmine/jasmine-1.3.1",
        "jasmine-html": "_assets/libs/jasmine/jasmine-html-1.3.1",
        "async": "_assets/libs/async/async-0.2.9",
        "modernizr": "_assets/libs/modernizr/modernizr-2.6.2.min",
        "moment": "_assets/libs/moment/moment-2.4.0.min",
        'highcharts-default': '_assets/libs/highcharts/highcharts',
        'highcharts': '_assets/libs/highcharts/highcharts-more',

        // Theming
        "jquerymobile-config": "_assets/libs/jqm/jquery.mobile-config",

        // Utilities
        "parser": "core/utilities/parser",

        // Plugins
        "text": "_assets/libs/require/plugins/text",
        "jasminejquery": "_assets/libs/jquery/plugins/jasmine-jquery",
        "jquery.form": "_assets/libs/jquery/plugins/jquery.form.min-20130616",
        "jquery.formparams": "_assets/libs/jquery/plugins/jquery.formparams",
        "jquery-touchpunch": "_assets/libs/jqueryui/jquery.ui.touchpunch-0.2.2.min",
        "jquerymobile-autocomplete": "_assets/libs/jqm/jqm-autocomplete/jquery.mobile.accessible-autocomplete",
        "jquerymobile-datepicker": "_assets/libs/jqm/jqm-datepicker/jquery.accessibleDatePicker",
        "jquerymobile-timepicker": "_assets/libs/jqm/jqm-timepicker/jquery.accessibleTimePicker",

        "Portal": "core/Portal",
        "Controller": "core/Controller",
        "Router": "core/Router",
        "Init": "core/init",
        "OrdersViewer": "widgets/orders-viewer/jquery.mobile.ordersManagement-0.1",
        "NoteWriter": "widgets/note-writer/jquery.mobile.progressNotes-0.1",

        // Test directory
        "test": "test"
    },
    // Sets the configuration for your third party scripts that are not AMD compatible
    shim: {
        "jquerymobile": {
            deps: ["jquery", "jquerymobile-config", "jqueryui"]
        },
        "jquerymobile-autocomplete": {
            deps: ["jquery", "jquerymobile"]
        },
        "jquerymobile-datepicker": {
            deps: ["jquery", "jquerymobile"]
        },
        "jquerymobile-timepicker": {
            deps: ["jquery", "jquerymobile"]
        },
        "jquery-touchpunch": {
            deps: ["jqueryui"]
        },
        "OrdersViewer": {
            deps: ["jquery", "jquerymobile"]
        },
        "NoteWriter": {
            deps: ["jquery", "jquerymobile", "jquerymobile-autocomplete", "jquerymobile-datepicker", "jquerymobile-timepicker"]
        },
        'highcharts-default': {
            deps: ['jquery']
        },
        'highcharts': {
            deps: ['highcharts-default'],
            "exports": "Highcharts"
        },
        "backbone": {
            "deps": ["underscore", "jquery"],
            "exports": "Backbone"
        },
        "marionette": {
            "deps": ["underscore", "backbone", "jquery"],
            "exports": "Marionette"
        },
        "handlebars": {
            "exports": "Handlebars"
        },
        "jasmine": {
            "exports": "jasmine"
        },
        "jasmine-html": {
            "deps": ["jasmine"],
            "exports": "jasmine"
        },
        "modernizr": {
            "exports": "modernizr"
        }
    },
    // hbs config - must duplicate in Gruntfile.js Require build
    hbs: {
        templateExtension: "html",
        helperDirectory: "_assets/templates/helpers/",
        i18nDirectory: "_assets/templates/i18n/",

        compileOptions: {}        // options object which is passed to Handlebars compiler
    }
});
require(['Init']);
